import { jsx } from "react/jsx-runtime";
import { useDefaultUiAssetUrlsWithOverrides } from "../assetUrls.mjs";
import { ToolsProvider } from "../hooks/useTools.mjs";
import { TranslationProvider } from "../hooks/useTranslation/useTranslation.mjs";
import { useMergedOverrides, useMergedTranslationOverrides } from "../overrides.mjs";
import { ActionsProvider } from "./actions.mjs";
import { AssetUrlsProvider } from "./asset-urls.mjs";
import { BreakPointProvider } from "./breakpoints.mjs";
import { TldrawUiComponentsProvider } from "./components.mjs";
import { DialogsProvider } from "./dialogs.mjs";
import { UiEventsProvider } from "./events.mjs";
import { ToastsProvider } from "./toasts.mjs";
function TldrawUiContextProvider({
  overrides,
  components,
  assetUrls,
  onUiEvent,
  forceMobile,
  children
}) {
  return /* @__PURE__ */ jsx(AssetUrlsProvider, { assetUrls: useDefaultUiAssetUrlsWithOverrides(assetUrls), children: /* @__PURE__ */ jsx(TranslationProvider, { overrides: useMergedTranslationOverrides(overrides), children: /* @__PURE__ */ jsx(UiEventsProvider, { onEvent: onUiEvent, children: /* @__PURE__ */ jsx(ToastsProvider, { children: /* @__PURE__ */ jsx(DialogsProvider, { children: /* @__PURE__ */ jsx(BreakPointProvider, { forceMobile, children: /* @__PURE__ */ jsx(TldrawUiComponentsProvider, { overrides: components, children: /* @__PURE__ */ jsx(InternalProviders, { overrides, children }) }) }) }) }) }) }) });
}
function InternalProviders({
  overrides,
  children
}) {
  const mergedOverrides = useMergedOverrides(overrides);
  return /* @__PURE__ */ jsx(ActionsProvider, { overrides: mergedOverrides.actions, children: /* @__PURE__ */ jsx(ToolsProvider, { overrides: mergedOverrides.tools, children }) });
}
export {
  TldrawUiContextProvider
};
//# sourceMappingURL=TldrawUiContextProvider.mjs.map
